#include "main.h"

Sea* gSea = 0;

// Set up the global conditions for the games.
// Globals(long initNumGolds, long initNumShips, long initGridSize, long initNumRocks, long initNumSimulationTimeSteps, long initNumSimulationRepeatRuns);
Globals gGlobal(
20,					// number of gold markers (must be less than the number of grid cells in the sea)
10,					// number of ships (must be less than the number of grid cells in the sea minus the number of rocks in the sea)
20,					// sea grid size (counted in grid cells)
60,					// approximate number of rocks within the sea (must be less than the number of grid cells in the sea)
10000,				// number of time steps in a game
10					// number of games to be played
);

// A simple random number functuon for widespread use
long lrandBetween(long lowBound, long highBound)
{	return (lowBound + (random() % (highBound - lowBound + 1)));	}

// A function to exit the code cleanly, printing a message
void cleanQuit(const char* quitMessage="")
{	
	std::cerr << "\n" << quitMessage;
	std::cerr << "\nQuitting cleanly";
	
	exit(0);
}

// Restart the game from scratch
void restart(void)
{
	delete gSea;
	gSea = new Sea(gGlobal.seaGridSize, gGlobal.seaNumShips);
}

// Output a "usage" message if start-up command line arguments are improperly specified
void usage(int argc, char **argv);
void usage(int argc, char **argv)
{
	// std::cout << "\nUSAGE: " << argv[0] << "(optional) <input Sea FileName>\n";
	std::cout << "\nUSAGE: " << argv[0] << "(optional) <simulation time steps> <#simulation runs>\n";
	cleanQuit();
}

// -------------------------------------------

int main (int argc, char *argv[])
{
	// default window size
	long winCols=1024, winRows=768, windowID=-1;
	
	// Seed the random number generator
	// You might need to replace this line with the seed function (e.g. srand() on your own platform).
	srandom((unsigned int)7707);
	
	if (argc == 1)
	{	gSea = new Sea(gGlobal.seaGridSize, gGlobal.seaNumShips);	}
	
	else if (argc == 2)
	{
		/* disabled save and reload games...
		gSea = new Sea();
		ifstream inFile;
		inFile.open(argv[1], ios::in);
		if (inFile.fail())
		{
			std::cerr << "\nError could not open input file: " << argv[1];
			usage(argc, argv);
		}
		else
		{
			std::cerr << "\nReading in Patch file: " << argv[1];
			gSea->fileInput(inFile);
			inFile.close();
		}
		*/
		usage(argc, argv);
	}
	
	else if (argc == 3)
	{
		gSea = new Sea(gGlobal.seaGridSize, gGlobal.seaNumShips);
		
		gGlobal.numSimulationTimeSteps	= atoi(argv[1]);
		gGlobal.numSimulationRepeatRuns	= atoi(argv[2]);
	}
	
	else
	{	usage(argc, argv);	}
	
	std::cout<< "\nPirates! will run " << gGlobal.numSimulationRepeatRuns << " times for " << gGlobal.numSimulationTimeSteps << " time steps." << std::endl;
	
	glutInit(&argc, argv);
	glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize (winCols, winRows);
	glutInitWindowPosition (5, 10);
	windowID = glutCreateWindow ("Pirates!");
	
	// enter full screen game mode (code is not written to adjust aspect ratio)
	// glutFullScreen();
	
	// carry out personal (non-GLUT) initialisation as necessary in this routine
	initGL (windowID);
	
	// specify GLUT event handlers
	glutDisplayFunc(display);
	glutVisibilityFunc(visible);
	glutReshapeFunc(reshape);
	glutKeyboardFunc(keyboard);
	glutMouseFunc(mouse);
	glutMotionFunc(mouseMove);
	glutPassiveMotionFunc(mousePassiveMove);
	glutIdleFunc(animate);

	glutMenu();
	
	// do an initial clear of the screen
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	// enter the GLUT event loop
	glutMainLoop();
	
	return 0;
}
